#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// TangleMod01.fsh  by   jaburns
//https://www.shadertoy.com/view/td3SWX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define EPS         0.005
#define ITERATIONS  100
#define MAX_DIST    50.

// https://iquilezles.org/articles/distfunctions
float sdCappedTorus(in vec3 p, in vec2 sc, in float ra, in float rb)
{
  p.x = abs(p.x);
  float k = (sc.y*p.x>sc.x*p.y) ? dot(p.xy,sc) : length(p.xy);
  return sqrt( dot(p,p) + ra*ra - 2.0*ra*k ) - rb;
}
float sdBox( vec3 p, vec3 b )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}

float hash31( vec3 p )
{
	return fract(sin(dot(p ,vec3(12.9898,78.233,91.495))) * 43758.5453);
}


mat2 rot( float theta )
{
    float c = cos( theta );
    float s = sin( theta );
    return mat2( c, s, -s, c );
}

float tile( vec3 op, vec3 p, int kind, vec3 cell ) // kind: [0,8)
{
    const float PI_4 = 3.14159/4.;
    const float PI_2 = 3.14159/2.;
    const vec2 SC = vec2(sin(PI_4), cos(PI_4));
    const mat2 ROT = mat2(cos(PI_4), sin(PI_4), -sin(PI_4), cos(PI_4));
    const mat2 ROT2 = mat2(cos(PI_2), sin(PI_2), -sin(PI_2), cos(PI_2));
    const mat2 nROT = mat2(cos(PI_4), -sin(PI_4), sin(PI_4), cos(PI_4));
    
    op /= 2.;
    float to = dot(op,op);
    float rb = .05 + .02*sin(to);
    
    if (kind >= 4) p.yz = p.zy;
    for (int i = 0; i < kind % 4; ++i) p.yz *= ROT2;   
    
    vec3 q;
    q = p;
    q.xy += vec2(-.5,.5);
    q.xy *= ROT;
    float A = sdCappedTorus( q, SC, .5, rb );

    q = p.xzy;
    q.xy += vec2(.5,.5);
    q.xy *= nROT;
    float B = sdCappedTorus( q, SC, .5, rb );
    
    q = vec3(p.y, -p.z, p.x);
    q.xy += vec2(-.5,.5);
    q.xy *= ROT;
    float C = sdCappedTorus( q, SC, .5, rb );
    
    return min(A, min(B, C));
}

struct Map
{
    float dist;
    vec3 cell;
};

Map map( vec3 p )
{
    vec3 q = mod(p + .5, 1.) - .5;
    vec3 cell = floor(p + .5);
    int kind = int(8.*hash31(cell));
   
    float leftBox   = 1000.; //sdBox( p - vec3( 1, 0,0), vec3(.5) );
	float rightBox  = sdBox( p - vec3(-1, 0,0), vec3(.5) );
    float bottomBox = sdBox( p - vec3( 0,-1,0), vec3(.5) );
    float boxes = min(bottomBox, min(leftBox, rightBox));
    boxes = 1000.;
    
    float tile = tile(p, q, kind, cell);
        
    return Map(min(boxes, tile), cell);
}

struct March
{
    vec3 pos;
    float dist;
    float ao;
};
   
March march( vec3 ro, vec3 rd )
{
    Map dist;
    float totalDist = 0.0;
    int i;
    for(  i =0; i < ITERATIONS; ++i )
    {
        dist = map( ro );
        if( dist.dist < EPS || totalDist > MAX_DIST ) break;
        totalDist += dist.dist;
        ro += dist.dist * rd;
    }
    
    return March( ro, dist.dist < EPS ? totalDist : -1.0, .25*float(i) / 100. );
}

vec3 getNormal(vec3 p)
{
    vec2 e = vec2(EPS, 0);
    return normalize(vec3(
        map(p + e.xyy).dist - map(p - e.xyy).dist,
        map(p + e.yxy).dist - map(p - e.yxy).dist,
        map(p + e.yyx).dist - map(p - e.yyx).dist));
}

vec3 skybox( vec3 d )
{
    return .4 + .3*normalize(d);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord - .5*iResolution.xy)/iResolution.y;
    vec3 ro = vec3(5.5,.5,.5);
    vec3 rd = normalize(vec3(uv, 1));
    
    float t = .3*iTime;
    ro.xy *= rot(.4*t);
    rd.yz *= rot(.7*t);
    rd.xz *= rot(.3*t);

    March m = march( ro, rd );
    
	vec3 bgcolor = skybox(rd);
    vec3 color = bgcolor;
    float lightness = 0.;
    
    if( m.dist >= 0.0 )
    {
        color = .6+.4*cos(m.pos.zxy+m.pos.xyz);
        vec3 normal = getNormal(m.pos);
        color = mix(color, 2.*skybox(reflect(rd, normal)), .4);
        
        lightness = max(0., (exp(-.1*(m.dist)) - m.ao));
    }
    
    const float GAMMA = 2.2;
    color = pow(color, vec3(1. / GAMMA));
    fragColor = vec4(mix(bgcolor,color,lightness),1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

